local ALName, ALPrivate = ...

local AtlasLoot = _G.AtlasLoot
local VendorPrice = {}
AtlasLoot.Data.VendorPrice = VendorPrice
local AL = AtlasLoot.Locales

local PRICE_INFO_LIST = {
	--- Classic
	-- items
	["burningblossom"] 	= { itemID = 23247 }, -- Burning Blossom
	["ancestrycoin"] 	= { itemID = 21100 }, -- Coin of Ancestry

	-- others
	["money"] 			= { func = GetCoinTextureString },

	--- BC
	["holydust"] = { itemID = 29735 }, -- Holy Dust (Aldor)
	["arcanerune"] = { itemID = 29736 }, -- Holy Dust (Scryers)
	["SpiritShard"] = { itemID = 28558 }, -- Spirit Shard
	["HalaaRT"] = { itemID = 26044 }, -- Halaa Research Token
	["HalaaBT"] = { itemID = 26045 }, -- Halaa Battle Token
	["MarkOfThrallmar"] = { itemID = 24581 }, -- Mark of Thrallmar
	["MarkOfHonorHold"] = { itemID = 24579 }, -- Mark of Honor Hold
	["BoJ"] = { itemID = 29434 }, -- Badge of Justice
	["glowcap"] = { itemID = 24245 }, -- Glowcap
	["ApexisC"] = { itemID = 32572 }, -- Apexis Crystal
	["ApexisS"] = { itemID = 32569 }, -- Apexis Shard
	["Brewfest"] = { itemID = 37829 }, -- Brewfest Prize Token
	-- pvp
	["honor"] = { currencyID = 1901 }, -- Honor
	["arena"] = { currencyID = 1900 },  -- Arena
	["honorH"] = { currencyID = 1901 }, -- Honor / Horde
	["honorA"] = { currencyID = 1901 }, -- Honor / Alli
	["pvpAlterac"] = { itemID = 20560 }, -- Alterac Valley Mark of Honor
	["pvpWarsong"] = { itemID = 20558 }, -- Warsong Gulch Mark of Honor
	["pvpArathi"] = { itemID = 20559 }, -- Arathi Basin Mark of Honor
	["pvpEye"] = { itemID = 29024 }, -- Eye of the Storm Mark of Honor
}

local VENDOR_PRICES = {
--@version-bcc@
    [39477] = "Brewfest:5",
    [39476] = "Brewfest:5",
    [38628] = "money:320000",
    [38229] = "glowcap:25",
    [37816] = "Brewfest:20",
    [37750] = "Brewfest:2",
    [37737] = "Brewfest:200",
    [37736] = "Brewfest:200",
    [35906] = "pvpAlterac:30:pvpArathi:30:pvpWarsong:30",
    [35415] = "money:288237",
    [35408] = "money:145302",
    [35403] = "money:135104",
    [35394] = "money:232527",
    [35387] = "money:110408",
    [35385] = "money:165115",
    [35379] = "money:226822",
    [35374] = "money:149973",
    [35367] = "money:146143",
    [35365] = "money:201430",
    [35358] = "money:202894",
    [35347] = "money:138594",
    [35342] = "money:173807",
    [35336] = "money:127597",
    [35329] = "money:104726",
    [34478] = "glowcap:30",
    [34175] = "money:144000",
    [34174] = "money:152000",
    [34173] = "money:144000",
    [34172] = "money:152000",
    [34129] = "pvpAlterac:30:pvpArathi:30:pvpWarsong:30",
    [34028] = "Brewfest:600",
    [34008] = "Brewfest:100",
    [33999] = "money:17000000",
    [33978] = "Brewfest:600",
    [33969] = "Brewfest:50",
    [33968] = "Brewfest:50",
    [33967] = "Brewfest:50",
    [33966] = "Brewfest:100",
    [33952] = "arena:1000",
    [33951] = "arena:500",
    [33949] = "arena:1000",
    [33948] = "arena:500",
    [33946] = "arena:1000",
    [33945] = "arena:500",
    [33943] = "arena:1000",
    [33942] = "arena:500",
    [33940] = "arena:1000",
    [33939] = "arena:500",
    [33937] = "arena:1000",
    [33936] = "arena:500",
    [33935] = "money:3400",
    [33934] = "money:3400",
    [33927] = "Brewfest:100",
    [33868] = "Brewfest:100",
    [33864] = "Brewfest:50",
    [33863] = "Brewfest:200",
    [33862] = "Brewfest:200",
    [33313] = "arena:1875",
    [33309] = "arena:1875",
    [33149] = "money:85000",
    [33078] = "arena:1000",
    [33077] = "arena:1000",
    [33076] = "arena:1000",
    [33068] = "honor:15300:pvpEye:10",
    [33067] = "honor:15300:pvpEye:10",
    [33066] = "honor:15300:pvpEye:10",
    [33065] = "honor:15300:pvpEye:10",
    [33064] = "honor:15300:pvpAlterac:10",
    [33057] = "honor:15300:pvpAlterac:10",
    [33056] = "honor:15300:pvpAlterac:10",
    [33047] = "Brewfest:100",
    [32999] = "honor:17850:pvpEye:40",
    [32998] = "honor:17850:pvpArathi:40",
    [32997] = "honor:11794:pvpWarsong:20",
    [32990] = "honor:17850:pvpEye:40",
    [32989] = "honor:11794:pvpWarsong:20",
    [32988] = "honor:17850:pvpArathi:40",
    [32981] = "honor:17850:pvpEye:40",
    [32980] = "honor:11794:pvpWarsong:20",
    [32979] = "honor:17850:pvpArathi:40",
    [32978] = "honor:17850:pvpEye:40",
    [32977] = "honor:11794:pvpWarsong:20",
    [32976] = "honor:17850:pvpArathi:40",
    [32975] = "honor:8925:pvpEye:40",
    [32974] = "honor:8925:pvpArathi:40",
    [32973] = "honor:5897:pvpWarsong:20",
    [32964] = "arena:3150",
    [32963] = "arena:3150",
    [32962] = "arena:1000",
    [32961] = "arena:1125",
    [32948] = "SpiritShard:2",
    [32947] = "SpiritShard:2",
    [32828] = "ApexisS:10",
    [32821] = "honor:11794:pvpWarsong:20",
    [32820] = "honor:11794:pvpWarsong:20",
    [32819] = "honor:11794:pvpWarsong:20",
    [32818] = "honor:11794:pvpWarsong:20",
    [32817] = "honor:11794:pvpWarsong:20",
    [32816] = "honor:11794:pvpWarsong:20",
    [32814] = "honor:11794:pvpWarsong:20",
    [32813] = "honor:11794:pvpWarsong:20",
    [32812] = "honor:11794:pvpWarsong:20",
    [32811] = "honor:11794:pvpWarsong:20",
    [32810] = "honor:11794:pvpWarsong:20",
    [32809] = "honor:11794:pvpWarsong:20",
    [32808] = "honor:17850:pvpArathi:40",
    [32807] = "honor:17850:pvpArathi:40",
    [32806] = "honor:17850:pvpArathi:40",
    [32805] = "honor:17850:pvpArathi:40",
    [32804] = "honor:17850:pvpArathi:40",
    [32803] = "honor:17850:pvpArathi:40",
    [32802] = "honor:17850:pvpArathi:40",
    [32801] = "honor:17850:pvpArathi:40",
    [32800] = "honor:17850:pvpArathi:40",
    [32799] = "honor:17850:pvpArathi:40",
    [32798] = "honor:17850:pvpArathi:40",
    [32797] = "honor:17850:pvpArathi:40",
    [32796] = "honor:17850:pvpEye:40",
    [32795] = "honor:17850:pvpEye:40",
    [32794] = "honor:17850:pvpEye:40",
    [32793] = "honor:17850:pvpEye:40",
    [32792] = "honor:17850:pvpEye:40",
    [32791] = "honor:17850:pvpEye:40",
    [32790] = "honor:17850:pvpEye:40",
    [32789] = "honor:17850:pvpEye:40",
    [32788] = "honor:17850:pvpEye:40",
    [32787] = "honor:17850:pvpEye:40",
    [32786] = "honor:17850:pvpEye:40",
    [32785] = "honor:17850:pvpEye:40",
    [32784] = "ApexisS:2",
    [32783] = "ApexisS:3",
    [32771] = "money:32984",
    [32770] = "money:32984",
    [32722] = "money:3200",
    [32721] = "money:3600",
    [32654] = "ApexisC:1:ApexisS:50",
    [32653] = "ApexisC:1:ApexisS:50",
    [32652] = "ApexisC:1:ApexisS:50",
    [32651] = "ApexisC:4:ApexisS:100",
    [32650] = "ApexisC:1:ApexisS:50",
    [32648] = "ApexisC:4:ApexisS:100",
    [32647] = "ApexisC:4:ApexisS:100",
    [32645] = "ApexisC:4:ApexisS:100",
    [32539] = "money:110533",
    [32538] = "money:110153",
    [32455] = "money:1080:honor:1",
    [32453] = "money:2500",
    [32452] = "arena:500",
    [32451] = "arena:1575",
    [32450] = "arena:1575",
    [32445] = "money:8000",
    [32319] = "money:1600000",
    [32318] = "money:1600000",
    [32317] = "money:1600000",
    [32316] = "money:1600000",
    [32314] = "money:1600000",
    [32233] = "money:5000",
    [32090] = "BoJ:50",
    [32089] = "BoJ:50",
    [32088] = "BoJ:50",
    [32087] = "BoJ:50",
    [32086] = "BoJ:50",
    [32085] = "BoJ:50",
    [32084] = "BoJ:50",
    [32083] = "BoJ:50",
    [32070] = "money:34000",
    [32060] = "arena:1875",
    [32059] = "arena:1500",
    [32058] = "arena:1875",
    [32057] = "arena:1875",
    [32056] = "arena:1125",
    [32055] = "arena:3750",
    [32054] = "arena:1000",
    [32053] = "arena:3150",
    [32052] = "arena:2625",
    [32051] = "arena:1875",
    [32050] = "arena:1875",
    [32049] = "arena:1125",
    [32048] = "arena:1875",
    [32047] = "arena:1500",
    [32046] = "arena:1125",
    [32045] = "arena:1875",
    [32044] = "arena:2625",
    [32043] = "arena:1500",
    [32042] = "arena:1875",
    [32041] = "arena:1875",
    [32040] = "arena:1125",
    [32039] = "arena:1875",
    [32038] = "arena:1875",
    [32037] = "arena:1500",
    [32036] = "arena:1875",
    [32035] = "arena:1875",
    [32034] = "arena:1125",
    [32033] = "arena:1500",
    [32032] = "arena:1875",
    [32031] = "arena:1875",
    [32030] = "arena:1125",
    [32029] = "arena:1875",
    [32028] = "arena:2625",
    [32027] = "arena:1125",
    [32026] = "arena:2625",
    [32025] = "arena:3750",
    [32024] = "arena:1500",
    [32023] = "arena:1875",
    [32022] = "arena:1875",
    [32021] = "arena:1125",
    [32020] = "arena:1875",
    [32019] = "arena:1875",
    [32018] = "arena:1500",
    [32017] = "arena:1875",
    [32016] = "arena:1875",
    [32015] = "arena:1125",
    [32014] = "arena:3750",
    [32013] = "arena:1500",
    [32012] = "arena:1875",
    [32011] = "arena:1875",
    [32010] = "arena:1125",
    [32009] = "arena:1875",
    [32008] = "arena:1500",
    [32007] = "arena:1875",
    [32006] = "arena:1875",
    [32005] = "arena:1125",
    [32004] = "arena:1875",
    [32003] = "arena:1125",
    [32002] = "arena:1875",
    [32001] = "arena:1500",
    [32000] = "arena:1875",
    [31999] = "arena:1875",
    [31998] = "arena:1125",
    [31997] = "arena:1875",
    [31996] = "arena:1500",
    [31995] = "arena:1875",
    [31993] = "arena:1125",
    [31992] = "arena:1875",
    [31991] = "arena:1875",
    [31990] = "arena:1500",
    [31989] = "arena:1875",
    [31988] = "arena:1875",
    [31987] = "arena:1125",
    [31986] = "arena:3750",
    [31985] = "arena:1125",
    [31984] = "arena:3750",
    [31983] = "arena:1875",
    [31982] = "arena:1875",
    [31981] = "arena:1125",
    [31980] = "arena:1875",
    [31979] = "arena:1500",
    [31978] = "arena:1125",
    [31977] = "arena:1875",
    [31976] = "arena:1500",
    [31975] = "arena:1875",
    [31974] = "arena:1875",
    [31973] = "arena:1125",
    [31972] = "arena:1875",
    [31971] = "arena:1500",
    [31969] = "arena:1875",
    [31968] = "arena:1875",
    [31967] = "arena:1125",
    [31966] = "arena:3750",
    [31965] = "arena:2625",
    [31964] = "arena:1500",
    [31963] = "arena:1875",
    [31962] = "arena:1875",
    [31961] = "arena:1125",
    [31960] = "arena:1875",
    [31959] = "arena:3750",
    [31958] = "arena:1125",
    [31949] = "money:4250",
    [31855] = "pvpWarsong:2",
    [31854] = "pvpEye:2",
    [31853] = "pvpWarsong:2",
    [31852] = "pvpEye:2",
    [31841] = "pvpAlterac:2",
    [31840] = "pvpArathi:2",
    [31839] = "pvpAlterac:2",
    [31838] = "pvpArathi:2",
    [31836] = "money:630000",
    [31835] = "money:665000",
    [31834] = "money:630000",
    [31833] = "money:665000",
    [31832] = "money:630000",
    [31831] = "money:665000",
    [31830] = "money:630000",
    [31829] = "money:665000",
    [31804] = "money:8500",
    [31775] = "glowcap:10",
    [31774] = "money:9000",
    [31773] = "money:9500",
    [31650] = "honor:12622:pvpArathi:20",
    [31649] = "honor:20081:pvpWarsong:30",
    [31648] = "honor:20081:pvpAlterac:30",
    [31647] = "honor:12622:pvpAlterac:20",
    [31646] = "honor:20655:pvpArathi:30",
    [31644] = "honor:6311:pvpArathi:20",
    [31643] = "honor:10328:pvpWarsong:30",
    [31642] = "honor:10328:pvpAlterac:30",
    [31641] = "honor:6311:pvpAlterac:20",
    [31640] = "honor:10328:pvpArathi:30",
    [31639] = "honor:6311:pvpArathi:20",
    [31638] = "honor:10328:pvpWarsong:30",
    [31637] = "honor:10328:pvpAlterac:30",
    [31636] = "honor:6311:pvpAlterac:20",
    [31635] = "honor:10328:pvpArathi:30",
    [31634] = "honor:6311:pvpArathi:20",
    [31633] = "honor:10328:pvpWarsong:30",
    [31632] = "honor:10328:pvpAlterac:30",
    [31631] = "honor:6311:pvpAlterac:20",
    [31630] = "honor:10328:pvpArathi:30",
    [31629] = "honor:10328:pvpArathi:30",
    [31628] = "honor:6311:pvpArathi:20",
    [31627] = "honor:10328:pvpWarsong:30",
    [31626] = "honor:10328:pvpAlterac:30",
    [31625] = "honor:10328:pvpArathi:30",
    [31624] = "honor:6311:pvpArathi:20",
    [31623] = "honor:10328:pvpWarsong:30",
    [31622] = "honor:10328:pvpAlterac:30",
    [31621] = "honor:6311:pvpAlterac:20",
    [31620] = "honor:6311:pvpAlterac:20",
    [31619] = "arena:750",
    [31618] = "",
    [31616] = "",
    [31614] = "arena:500",
    [31613] = "",
    [31599] = "honor:5897:pvpWarsong:20",
    [31598] = "honor:11794:pvpWarsong:20",
    [31597] = "honor:8925:pvpEye:40",
    [31596] = "honor:8925:pvpArathi:40",
    [31595] = "honor:17850:pvpEye:40",
    [31594] = "honor:17850:pvpArathi:40",
    [31593] = "honor:10328:pvpArathi:30",
    [31592] = "honor:6311:pvpArathi:20",
    [31591] = "honor:10328:pvpWarsong:30",
    [31590] = "honor:10328:pvpAlterac:30",
    [31589] = "honor:6311:pvpAlterac:20",
    [31588] = "honor:20655:pvpArathi:30",
    [31587] = "honor:12622:pvpArathi:20",
    [31586] = "honor:20081:pvpWarsong:30",
    [31585] = "honor:20081:pvpAlterac:30",
    [31584] = "honor:12622:pvpAlterac:20",
    [31413] = "",
    [31412] = "arena:750",
    [31411] = "",
    [31410] = "",
    [31409] = "arena:500",
    [31407] = "arena:750",
    [31406] = "",
    [31402] = "money:102000",
    [31400] = "",
    [31397] = "arena:500",
    [31396] = "",
    [31392] = "money:204000",
    [31391] = "money:204000",
    [31390] = "money:204000",
    [31379] = "",
    [31378] = "arena:750",
    [31377] = "",
    [31376] = "",
    [31375] = "arena:500",
    [31356] = "money:34000",
    [30780] = "BoJ:20",
    [30779] = "BoJ:20",
    [30778] = "BoJ:30",
    [30776] = "BoJ:30",
    [30774] = "BoJ:20",
    [30773] = "BoJ:30",
    [30772] = "BoJ:30",
    [30770] = "BoJ:20",
    [30769] = "BoJ:30",
    [30768] = "BoJ:20",
    [30767] = "BoJ:20",
    [30766] = "BoJ:30",
    [30764] = "BoJ:20",
    [30763] = "BoJ:20",
    [30762] = "BoJ:30",
    [30761] = "BoJ:30",
    [30623] = "money:85000",
    [30498] = "honor:7905:pvpWarsong:60",
    [30497] = "honor:7905:pvpWarsong:60",
    [30490] = "arena:1500",
    [30489] = "arena:1875",
    [30488] = "arena:1875",
    [30487] = "arena:1125",
    [30486] = "arena:1875",
    [30444] = "money:45000",
    [30443] = "money:72000",
    [30351] = "honor:4000",
    [30350] = "honor:4000",
    [30349] = "honor:4000",
    [30348] = "honor:4000",
    [30346] = "honor:4000",
    [30345] = "honor:8000",
    [30344] = "honor:8000",
    [30343] = "honor:4000",
    [30201] = "",
    [30200] = "",
    [30188] = "arena:500",
    [30187] = "",
    [30186] = "arena:750",
    [30156] = "glowcap:1",
    [29721] = "money:102000",
    [29720] = "money:51000",
    [29664] = "money:47500",
    [29617] = "honor:8415:pvpArathi:20",
    [29616] = "honor:13005:pvpAlterac:30",
    [29615] = "honor:13770:pvpArathi:30",
    [29614] = "honor:13005:pvpWarsong:30",
    [29613] = "honor:8415:pvpAlterac:20",
    [29612] = "honor:8415:pvpArathi:20",
    [29611] = "honor:8415:pvpArathi:20",
    [29610] = "honor:13005:pvpAlterac:30",
    [29609] = "honor:13770:pvpArathi:30",
    [29608] = "honor:13005:pvpWarsong:30",
    [29607] = "honor:8415:pvpAlterac:20",
    [29606] = "honor:8415:pvpArathi:20",
    [29605] = "honor:2805:pvpArathi:20",
    [29604] = "honor:4335:pvpAlterac:30",
    [29603] = "honor:4335:pvpWarsong:30",
    [29602] = "honor:4590:pvpArathi:30",
    [29601] = "honor:2805:pvpArathi:20",
    [29600] = "honor:2805:pvpAlterac:20",
    [29599] = "honor:2805:pvpArathi:20",
    [29598] = "honor:4335:pvpAlterac:30",
    [29597] = "honor:4335:pvpWarsong:30",
    [29596] = "honor:4590:pvpArathi:30",
    [29595] = "honor:2805:pvpAlterac:20",
    [29594] = "honor:2805:pvpArathi:20",
    [29593] = "honor:2805",
    [29592] = "honor:2805",
    [29472] = "pvpAlterac:30:pvpArathi:30:pvpWarsong:30",
    [29471] = "pvpAlterac:30:pvpArathi:30:pvpWarsong:30",
    [29470] = "pvpAlterac:30:pvpArathi:30:pvpWarsong:30",
    [29469] = "pvpAlterac:30:pvpArathi:30:pvpWarsong:30",
    [29468] = "pvpAlterac:30:pvpArathi:30:pvpWarsong:30",
    [29467] = "pvpAlterac:30:pvpArathi:30:pvpWarsong:30",
    [29466] = "pvpAlterac:30:pvpArathi:30:pvpWarsong:30",
    [29465] = "pvpAlterac:30:pvpArathi:30:pvpWarsong:30",
    [29390] = "BoJ:15",
    [29389] = "BoJ:15",
    [29388] = "BoJ:15",
    [29387] = "BoJ:41",
    [29386] = "BoJ:25",
    [29385] = "BoJ:25",
    [29384] = "BoJ:25",
    [29383] = "BoJ:41",
    [29382] = "BoJ:25",
    [29381] = "BoJ:25",
    [29379] = "BoJ:25",
    [29376] = "BoJ:41",
    [29375] = "BoJ:25",
    [29374] = "BoJ:25",
    [29373] = "BoJ:25",
    [29370] = "BoJ:41",
    [29369] = "BoJ:25",
    [29368] = "BoJ:25",
    [29367] = "BoJ:25",
    [29275] = "BoJ:50",
    [29274] = "BoJ:25",
    [29273] = "BoJ:25",
    [29272] = "BoJ:25",
    [29271] = "BoJ:25",
    [29270] = "BoJ:25",
    [29269] = "BoJ:25",
    [29268] = "BoJ:33",
    [29267] = "BoJ:33",
    [29266] = "BoJ:33",
    [29231] = "money:900000",
    [29230] = "money:900000",
    [29229] = "money:900000",
    [29227] = "money:900000",
    [29219] = "money:108000",
    [29218] = "money:108000",
    [29217] = "money:108000",
    [29194] = "money:850000",
    [29192] = "money:850000",
    [29174] = "money:108265",
    [29173] = "money:149559",
    [29172] = "money:671595",
    [29171] = "money:2258294",
    [29170] = "money:671595",
    [29150] = "glowcap:45",
    [29149] = "glowcap:20",
    [29148] = "money:150969",
    [29147] = "money:158775",
    [29146] = "money:175951",
    [29145] = "money:167154",
    [29144] = "money:95000",
    [29143] = "money:95000",
    [29142] = "money:196936",
    [29141] = "money:218003",
    [29140] = "money:130313",
    [29139] = "money:120013",
    [29138] = "money:524391",
    [29137] = "money:496240",
    [29136] = "money:207130",
    [29135] = "money:196078",
    [29105] = "money:950000",
    [29104] = "money:950000",
    [29103] = "money:950000",
    [29102] = "money:950000",
    [29006] = "honor:5897:pvpWarsong:20",
    [29005] = "honor:8925:pvpEye:40",
    [29004] = "honor:8925:pvpArathi:40",
    [29003] = "honor:17850:pvpEye:40",
    [29002] = "honor:11794:pvpWarsong:20",
    [29001] = "honor:17850:pvpArathi:40",
    [29000] = "honor:8925:pvpEye:40",
    [28999] = "honor:5897:pvpWarsong:20",
    [28998] = "honor:8925:pvpArathi:40",
    [28997] = "honor:8925:pvpEye:40",
    [28996] = "honor:5897:pvpWarsong:20",
    [28995] = "honor:8925:pvpArathi:40",
    [28994] = "honor:8925:pvpEye:40",
    [28993] = "honor:8925:pvpArathi:40",
    [28992] = "honor:5897:pvpWarsong:20",
    [28991] = "honor:8925:pvpEye:40",
    [28990] = "honor:8925:pvpArathi:40",
    [28989] = "honor:5897:pvpWarsong:20",
    [28988] = "honor:5897:pvpWarsong:20",
    [28987] = "honor:8925:pvpEye:40",
    [28986] = "honor:8925:pvpArathi:40",
    [28985] = "honor:8925:pvpEye:40",
    [28984] = "honor:5897:pvpWarsong:20",
    [28983] = "honor:8925:pvpArathi:40",
    [28982] = "honor:17850:pvpEye:40",
    [28981] = "honor:11794:pvpWarsong:20",
    [28980] = "honor:17850:pvpArathi:40",
    [28978] = "honor:5897:pvpWarsong:20",
    [28977] = "honor:8925:pvpEye:40",
    [28976] = "honor:8925:pvpArathi:40",
    [28975] = "honor:8925:pvpEye:40",
    [28974] = "honor:8925:pvpArathi:40",
    [28973] = "honor:5897:pvpWarsong:20",
    [28960] = "honor:12750:pvpAlterac:40",
    [28959] = "honor:19125:pvpAlterac:40",
    [28957] = "honor:9563:pvpEye:20",
    [28956] = "honor:9563:pvpEye:20",
    [28955] = "honor:9563:pvpEye:20",
    [28954] = "honor:9563:pvpEye:20",
    [28953] = "honor:9563:pvpEye:20",
    [28952] = "honor:9563:pvpEye:20",
    [28951] = "honor:9563:pvpEye:20",
    [28950] = "honor:9563:pvpEye:20",
    [28949] = "honor:19125:pvpAlterac:40",
    [28948] = "honor:19125:pvpAlterac:40",
    [28947] = "honor:9563:pvpEye:20",
    [28946] = "honor:9563:pvpEye:20",
    [28945] = "honor:19125:pvpAlterac:40",
    [28944] = "honor:9563:pvpEye:20",
    [28943] = "honor:19125:pvpAlterac:40",
    [28942] = "honor:19125:pvpAlterac:40",
    [28941] = "honor:9563:pvpEye:20",
    [28940] = "honor:9563:pvpEye:20",
    [28939] = "honor:19125:pvpEye:20",
    [28938] = "honor:19125:pvpEye:20",
    [28937] = "honor:19125:pvpEye:20",
    [28935] = "honor:38250:pvpAlterac:40",
    [28933] = "honor:25500:pvpAlterac:40",
    [28931] = "honor:19125:pvpEye:20",
    [28930] = "honor:19125:pvpEye:20",
    [28929] = "honor:19125:pvpEye:20",
    [28928] = "honor:19125:pvpEye:20",
    [28926] = "honor:19125:pvpEye:20",
    [28925] = "honor:19125:pvpEye:20",
    [28924] = "honor:19125:pvpEye:20",
    [28923] = "honor:38250:pvpAlterac:40",
    [28922] = "honor:19125:pvpEye:20",
    [28921] = "honor:19125:pvpEye:20",
    [28920] = "honor:19125:pvpEye:20",
    [28919] = "honor:38250:pvpAlterac:40",
    [28918] = "honor:38250:pvpAlterac:40",
    [28917] = "honor:38250:pvpAlterac:40",
    [28875] = "honor:20655:pvpArathi:30",
    [28874] = "honor:12622:pvpArathi:20",
    [28873] = "honor:20081:pvpWarsong:30",
    [28872] = "honor:20081:pvpAlterac:30",
    [28871] = "honor:12622:pvpAlterac:20",
    [28870] = "honor:10328:pvpWarsong:30",
    [28869] = "honor:10328:pvpArathi:30",
    [28868] = "honor:6311:pvpAlterac:20",
    [28867] = "honor:10328:pvpAlterac:30",
    [28866] = "honor:6311:pvpArathi:20",
    [28865] = "honor:6311:pvpArathi:20",
    [28864] = "honor:10328:pvpWarsong:30",
    [28863] = "honor:10328:pvpAlterac:30",
    [28862] = "honor:6311:pvpAlterac:20",
    [28861] = "honor:10328:pvpArathi:30",
    [28860] = "honor:10328:pvpArathi:30",
    [28859] = "honor:6311:pvpArathi:20",
    [28858] = "honor:10328:pvpWarsong:30",
    [28857] = "honor:10328:pvpAlterac:30",
    [28856] = "honor:6311:pvpAlterac:20",
    [28855] = "honor:12622:pvpArathi:20",
    [28854] = "honor:20081:pvpWarsong:30",
    [28853] = "honor:20081:pvpAlterac:30",
    [28852] = "honor:12622:pvpAlterac:20",
    [28851] = "honor:20655:pvpArathi:30",
    [28850] = "honor:12622:pvpArathi:20",
    [28849] = "honor:20081:pvpWarsong:30",
    [28848] = "honor:20081:pvpAlterac:30",
    [28847] = "honor:12622:pvpAlterac:20",
    [28846] = "honor:20655:pvpArathi:30",
    [28845] = "honor:12622:pvpArathi:20",
    [28844] = "honor:20081:pvpWarsong:30",
    [28843] = "honor:20081:pvpAlterac:30",
    [28842] = "honor:12622:pvpAlterac:20",
    [28841] = "honor:20655:pvpArathi:30",
    [28840] = "honor:10328:pvpArathi:30",
    [28839] = "honor:6311:pvpArathi:20",
    [28838] = "honor:10328:pvpWarsong:30",
    [28837] = "honor:10328:pvpAlterac:30",
    [28836] = "honor:6311:pvpAlterac:20",
    [28835] = "honor:6311:pvpArathi:20",
    [28834] = "honor:10328:pvpWarsong:30",
    [28833] = "honor:10328:pvpAlterac:30",
    [28832] = "honor:6311:pvpAlterac:20",
    [28831] = "honor:10328:pvpArathi:30",
    [28821] = "honor:10328:pvpArathi:30",
    [28820] = "honor:6311:pvpArathi:20",
    [28819] = "honor:10328:pvpWarsong:30",
    [28818] = "honor:10328:pvpAlterac:30",
    [28817] = "honor:6311:pvpAlterac:20",
    [28815] = "honor:20655:pvpArathi:30",
    [28814] = "honor:12622:pvpArathi:20",
    [28813] = "honor:20081:pvpWarsong:30",
    [28812] = "honor:20081:pvpAlterac:30",
    [28811] = "honor:12622:pvpAlterac:20",
    [28809] = "honor:6311:pvpArathi:20",
    [28808] = "honor:10328:pvpWarsong:30",
    [28807] = "honor:10328:pvpAlterac:30",
    [28806] = "honor:6311:pvpAlterac:20",
    [28805] = "honor:10328:pvpArathi:30",
    [28761] = "SpiritShard:18",
    [28760] = "SpiritShard:18",
    [28759] = "SpiritShard:18",
    [28758] = "SpiritShard:18",
    [28724] = "honor:10328:pvpWarsong:30",
    [28723] = "honor:10328:pvpArathi:30",
    [28722] = "honor:6311:pvpArathi:20",
    [28721] = "honor:10328:pvpWarsong:30",
    [28720] = "honor:10328:pvpAlterac:30",
    [28719] = "honor:6311:pvpAlterac:20",
    [28718] = "honor:10328:pvpWarsong:30",
    [28717] = "honor:10328:pvpArathi:30",
    [28716] = "honor:6311:pvpAlterac:20",
    [28715] = "honor:10328:pvpAlterac:30",
    [28714] = "honor:6311:pvpArathi:20",
    [28713] = "honor:6311:pvpArathi:20",
    [28712] = "honor:10328:pvpWarsong:30",
    [28711] = "honor:10328:pvpAlterac:30",
    [28710] = "honor:6311:pvpAlterac:20",
    [28709] = "honor:10328:pvpArathi:30",
    [28708] = "honor:10328:pvpArathi:30",
    [28707] = "honor:6311:pvpArathi:20",
    [28706] = "honor:10328:pvpWarsong:30",
    [28705] = "honor:10328:pvpAlterac:30",
    [28704] = "honor:6311:pvpAlterac:20",
    [28703] = "honor:6311:pvpArathi:20",
    [28702] = "honor:10328:pvpWarsong:30",
    [28701] = "honor:10328:pvpAlterac:30",
    [28700] = "honor:6311:pvpAlterac:20",
    [28699] = "honor:10328:pvpArathi:30",
    [28698] = "honor:6311:pvpArathi:20",
    [28697] = "honor:10328:pvpWarsong:30",
    [28696] = "honor:10328:pvpAlterac:30",
    [28695] = "honor:6311:pvpAlterac:20",
    [28694] = "honor:10328:pvpArathi:30",
    [28693] = "honor:6311:pvpArathi:20",
    [28692] = "honor:10328:pvpWarsong:30",
    [28691] = "honor:10328:pvpAlterac:30",
    [28690] = "honor:6311:pvpAlterac:20",
    [28689] = "honor:10328:pvpArathi:30",
    [28688] = "honor:10328:pvpArathi:30",
    [28687] = "honor:6311:pvpArathi:20",
    [28686] = "honor:10328:pvpWarsong:30",
    [28685] = "honor:10328:pvpAlterac:30",
    [28684] = "honor:6311:pvpAlterac:20",
    [28683] = "honor:6311:pvpArathi:20",
    [28681] = "honor:10328:pvpAlterac:30",
    [28680] = "honor:6311:pvpAlterac:20",
    [28679] = "honor:10328:pvpArathi:30",
    [28646] = "honor:11794:pvpWarsong:20",
    [28645] = "honor:17850:pvpEye:40",
    [28644] = "honor:17850:pvpArathi:40",
    [28643] = "honor:11794:pvpWarsong:20",
    [28642] = "honor:17850:pvpEye:40",
    [28641] = "honor:17850:pvpArathi:40",
    [28640] = "honor:17850:pvpEye:40",
    [28639] = "honor:17850:pvpArathi:40",
    [28638] = "honor:11794:pvpWarsong:20",
    [28632] = "money:51000",
    [28630] = "honor:17850:pvpEye:40",
    [28629] = "honor:17850:pvpArathi:40",
    [28628] = "honor:10328:pvpArathi:30",
    [28627] = "honor:6311:pvpArathi:20",
    [28626] = "honor:10328:pvpWarsong:30",
    [28625] = "honor:10328:pvpAlterac:30",
    [28624] = "honor:6311:pvpAlterac:20",
    [28623] = "honor:10328:pvpArathi:30",
    [28622] = "honor:6311:pvpArathi:20",
    [28620] = "honor:10328:pvpWarsong:30",
    [28619] = "honor:10328:pvpAlterac:30",
    [28618] = "honor:6311:pvpAlterac:20",
    [28617] = "honor:6311:pvpArathi:20",
    [28616] = "honor:10328:pvpWarsong:30",
    [28615] = "honor:10328:pvpAlterac:30",
    [28614] = "honor:6311:pvpAlterac:20",
    [28613] = "honor:10328:pvpArathi:30",
    [28605] = "honor:11794:pvpWarsong:20",
    [28577] = "SpiritShard:18",
    [28576] = "SpiritShard:18",
    [28575] = "SpiritShard:18",
    [28574] = "SpiritShard:18",
    [28561] = "SpiritShard:18",
    [28560] = "SpiritShard:18",
    [28559] = "SpiritShard:18",
    [28557] = "SpiritShard:8",
    [28556] = "SpiritShard:8",
    [28555] = "SpiritShard:50",
    [28553] = "SpiritShard:50",
    [28476] = "arena:1875",
    [28451] = "honor:11794:pvpWarsong:20",
    [28450] = "honor:17850:pvpArathi:40",
    [28449] = "honor:17850:pvpEye:40",
    [28448] = "honor:11794:pvpWarsong:20",
    [28447] = "honor:17850:pvpEye:40",
    [28446] = "honor:17850:pvpArathi:40",
    [28445] = "honor:11794:pvpWarsong:20",
    [28444] = "honor:17850:pvpEye:40",
    [28443] = "honor:17850:pvpArathi:40",
    [28424] = "honor:11794:pvpWarsong:20",
    [28423] = "honor:17850:pvpArathi:40",
    [28422] = "honor:17850:pvpEye:40",
    [28411] = "honor:5897:pvpWarsong:20",
    [28410] = "honor:8925:pvpEye:40",
    [28409] = "honor:8925:pvpArathi:40",
    [28405] = "honor:5897:pvpWarsong:20",
    [28404] = "honor:8925:pvpArathi:40",
    [28402] = "honor:8925:pvpEye:40",
    [28385] = "honor:17850:pvpArathi:40",
    [28383] = "honor:17850:pvpEye:40",
    [28381] = "honor:11794:pvpWarsong:20",
    [28378] = "honor:5897:pvpArathi:20",
    [28377] = "honor:5897:pvpArathi:20",
    [28363] = "honor:4250",
    [28362] = "honor:3445",
    [28358] = "arena:1875",
    [28357] = "arena:500",
    [28356] = "arena:500",
    [28355] = "arena:500",
    [28346] = "arena:500",
    [28335] = "arena:500",
    [28334] = "",
    [28333] = "arena:750",
    [28332] = "",
    [28331] = "",
    [28320] = "arena:500",
    [28319] = "arena:500",
    [28314] = "arena:550",
    [28313] = "arena:1300",
    [28312] = "arena:1300",
    [28310] = "arena:550",
    [28309] = "arena:550",
    [28308] = "arena:1300",
    [28307] = "arena:550",
    [28305] = "arena:1300",
    [28302] = "arena:550",
    [28300] = "arena:1875",
    [28299] = "arena:1875",
    [28298] = "arena:1875",
    [28297] = "arena:1575",
    [28295] = "arena:1300",
    [28294] = "arena:1875",
    [28293] = "honor:38250:pvpAlterac:40",
    [28271] = "money:68000",
    [28247] = "honor:7650:pvpAlterac:10",
    [28246] = "honor:7650:pvpAlterac:10",
    [28245] = "honor:7650:pvpEye:10",
    [28244] = "honor:7650:pvpEye:10",
    [28243] = "honor:4000",
    [28242] = "honor:4000",
    [28241] = "honor:4000",
    [28240] = "honor:4000",
    [28239] = "honor:4000",
    [28238] = "honor:4000",
    [28237] = "honor:4000",
    [28236] = "honor:4000",
    [28235] = "honor:4000",
    [28234] = "honor:4000",
    [28140] = "",
    [28139] = "arena:750",
    [28138] = "",
    [28137] = "",
    [28136] = "arena:500",
    [28130] = "",
    [28129] = "arena:750",
    [28128] = "",
    [28127] = "",
    [28126] = "arena:500",
    [28123] = "honor:4250",
    [28120] = "honor:3445",
    [28119] = "honor:3445",
    [28118] = "honor:3445",
    [27883] = "arena:750",
    [27882] = "",
    [27881] = "",
    [27880] = "arena:500",
    [27879] = "",
    [27711] = "",
    [27710] = "arena:750",
    [27709] = "",
    [27708] = "",
    [27707] = "arena:500",
    [27706] = "arena:750",
    [27705] = "",
    [27704] = "",
    [27703] = "arena:500",
    [27702] = "",
    [27689] = "glowcap:2",
    [27473] = "arena:750",
    [27472] = "",
    [27471] = "",
    [27470] = "arena:500",
    [27469] = "",
    [26001] = "",
    [26000] = "arena:500",
    [25999] = "arena:750",
    [25998] = "",
    [25997] = "",
    [25869] = "money:68000",
    [25858] = "",
    [25857] = "arena:500",
    [25856] = "",
    [25855] = "",
    [25854] = "arena:750",
    [25838] = "money:153980",
    [25836] = "money:305748",
    [25835] = "money:380785",
    [25834] = "arena:500",
    [25833] = "",
    [25832] = "arena:750",
    [25831] = "",
    [25830] = "",
    [25829] = "honor:11475:pvpEye:10",
    [25828] = "glowcap:15",
    [25827] = "glowcap:25",
    [25743] = "money:114000",
    [25742] = "money:114000",
    [25741] = "money:114000",
    [25737] = "money:119000",
    [25736] = "money:119000",
    [25735] = "money:136000",
    [25550] = "glowcap:1",
    [25548] = "glowcap:1",
    [25526] = "money:51000",
    [24557] = "arena:1875",
    [24556] = "arena:500",
    [24555] = "",
    [24554] = "arena:750",
    [24553] = "",
    [24552] = "",
    [24551] = "honor:22950:pvpEye:10",
    [24550] = "arena:1875",
    [24549] = "arena:500",
    [24547] = "",
    [24546] = "arena:750",
    [24545] = "",
    [24544] = "",
    [24539] = "glowcap:2",
    [24429] = "money:6800",
    [24417] = "money:1700",
    [24183] = "money:102000",
    [23814] = "money:51000",
    [23618] = "money:51000",
    [23469] = "honor:9563:pvpArathi:20",
    [23468] = "honor:9563:pvpArathi:20",
    [23467] = "honor:9563:pvpArathi:20",
    [23466] = "honor:9563:pvpArathi:20",
    [23465] = "honor:19125:pvpAlterac:40",
    [23464] = "honor:9563:pvpArathi:20",
    [23456] = "honor:9563:pvpArathi:20",
    [23455] = "honor:19125:pvpAlterac:40",
    [23454] = "honor:9563:pvpArathi:20",
    [23453] = "honor:9563:pvpArathi:20",
    [23452] = "honor:9563:pvpArathi:20",
    [23451] = "honor:9563:pvpArathi:20",
    [23319] = "honor:2805:pvpArathi:20",
    [23318] = "honor:4335:pvpAlterac:30",
    [23317] = "honor:2805:pvpArathi:20",
    [23316] = "honor:4335:pvpAlterac:30",
    [23315] = "honor:2805:pvpArathi:20",
    [23314] = "honor:4335:pvpAlterac:30",
    [23313] = "honor:2805:pvpArathi:20",
    [23312] = "honor:4335:pvpAlterac:30",
    [23311] = "honor:2805:pvpArathi:20",
    [23310] = "honor:4335:pvpAlterac:30",
    [23309] = "honor:2805:pvpArathi:20",
    [23308] = "honor:4335:pvpAlterac:30",
    [23307] = "honor:2805:pvpArathi:20",
    [23306] = "honor:4335:pvpAlterac:30",
    [23305] = "honor:4590:pvpArathi:30",
    [23304] = "honor:4335:pvpWarsong:30",
    [23303] = "honor:4590:pvpArathi:30",
    [23302] = "honor:4335:pvpWarsong:30",
    [23301] = "honor:4335:pvpWarsong:30",
    [23300] = "honor:4590:pvpArathi:30",
    [23299] = "honor:4335:pvpWarsong:30",
    [23298] = "honor:4590:pvpArathi:30",
    [23297] = "honor:4590:pvpArathi:30",
    [23296] = "honor:4335:pvpWarsong:30",
    [23295] = "honor:4335:pvpWarsong:30",
    [23294] = "honor:4590:pvpArathi:30",
    [23293] = "honor:4335:pvpWarsong:30",
    [23292] = "honor:4590:pvpArathi:30",
    [23291] = "honor:2805:pvpArathi:20",
    [23290] = "honor:2805:pvpAlterac:20",
    [23289] = "honor:2805:pvpArathi:20",
    [23288] = "honor:2805:pvpAlterac:20",
    [23287] = "honor:2805:pvpArathi:20",
    [23286] = "honor:2805:pvpAlterac:20",
    [23285] = "honor:2805:pvpArathi:20",
    [23284] = "honor:2805:pvpAlterac:20",
    [23283] = "honor:2805:pvpArathi:20",
    [23282] = "honor:2805:pvpAlterac:20",
    [23281] = "honor:2805:pvpArathi:20",
    [23280] = "honor:2805:pvpAlterac:20",
    [23279] = "honor:2805:pvpAlterac:20",
    [23278] = "honor:2805:pvpArathi:20",
    [23277] = "honor:2805:pvpArathi:20",
    [23276] = "honor:4335:pvpAlterac:30",
    [23275] = "honor:2805:pvpArathi:20",
    [23274] = "honor:2805:pvpAlterac:20",
    [23273] = "honor:4335:pvpWarsong:30",
    [23272] = "honor:4590:pvpArathi:30",
    [23264] = "honor:2805:pvpArathi:20",
    [23263] = "honor:4335:pvpAlterac:30",
    [23262] = "honor:2805:pvpArathi:20",
    [23261] = "honor:4335:pvpAlterac:30",
    [23260] = "honor:2805:pvpArathi:20",
    [23259] = "honor:4335:pvpAlterac:30",
    [23258] = "honor:2805:pvpArathi:20",
    [23257] = "honor:4335:pvpAlterac:30",
    [23256] = "honor:2805:pvpArathi:20",
    [23255] = "honor:4335:pvpAlterac:30",
    [23254] = "honor:2805:pvpArathi:20",
    [23253] = "honor:4335:pvpAlterac:30",
    [23252] = "honor:2805:pvpArathi:20",
    [23251] = "honor:4335:pvpAlterac:30",
    [23244] = "honor:4335:pvpAlterac:30",
    [23243] = "honor:2805:pvpArathi:20",
    [22922] = "money:85000",
    [22918] = "money:68000",
    [22917] = "money:76000",
    [22916] = "glowcap:25",
    [22906] = "glowcap:30",
    [22887] = "honor:4335:pvpWarsong:30",
    [22886] = "honor:4590:pvpArathi:30",
    [22885] = "honor:4590:pvpArathi:30",
    [22884] = "honor:4590:pvpArathi:30",
    [22883] = "honor:4335:pvpWarsong:30",
    [22882] = "honor:4335:pvpWarsong:30",
    [22881] = "honor:4335:pvpWarsong:30",
    [22880] = "honor:4335:pvpWarsong:30",
    [22879] = "honor:4590:pvpArathi:30",
    [22878] = "honor:4335:pvpWarsong:30",
    [22877] = "honor:4590:pvpArathi:30",
    [22876] = "honor:4590:pvpArathi:30",
    [22875] = "honor:4335:pvpWarsong:30",
    [22874] = "honor:4590:pvpArathi:30",
    [22873] = "honor:4335:pvpWarsong:30",
    [22872] = "honor:4590:pvpArathi:30",
    [22870] = "honor:2805:pvpAlterac:20",
    [22869] = "honor:2805:pvpAlterac:20",
    [22868] = "honor:2805:pvpAlterac:20",
    [22867] = "honor:2805:pvpAlterac:20",
    [22865] = "honor:2805:pvpAlterac:20",
    [22864] = "honor:2805:pvpAlterac:20",
    [22863] = "honor:2805:pvpAlterac:20",
    [22862] = "honor:2805:pvpAlterac:20",
    [22860] = "honor:2805:pvpArathi:20",
    [22859] = "honor:2805:pvpArathi:20",
    [22858] = "honor:2805:pvpArathi:20",
    [22857] = "honor:2805:pvpArathi:20",
    [22856] = "honor:2805:pvpArathi:20",
    [22855] = "honor:2805:pvpArathi:20",
    [22852] = "honor:2805:pvpArathi:20",
    [22843] = "honor:2805:pvpArathi:20",
    [22753] = "honor:8925:pvpWarsong:40",
    [22752] = "honor:8925:pvpWarsong:40",
    [22750] = "honor:8925:pvpWarsong:40",
    [22749] = "honor:8925:pvpWarsong:40",
    [22748] = "honor:8925:pvpWarsong:40",
    [22747] = "honor:8925:pvpWarsong:40",
    [22741] = "honor:8925:pvpWarsong:40",
    [22740] = "honor:8925:pvpWarsong:40",
    [22676] = "honor:8925:pvpWarsong:40",
    [22673] = "honor:8925:pvpWarsong:40",
    [22672] = "honor:8925:pvpWarsong:40",
    [22651] = "honor:8925:pvpWarsong:40",
    [21568] = "honor:118:pvpWarsong:30",
    [21567] = "honor:258:pvpWarsong:30",
    [21566] = "honor:118:pvpWarsong:30",
    [21565] = "honor:258:pvpWarsong:30",
    [21563] = "honor:4590:pvpAlterac:25",
    [21120] = "honor:175:pvpArathi:30",
    [21119] = "honor:175:pvpArathi:30",
    [21118] = "honor:258:pvpArathi:30",
    [21117] = "honor:382:pvpArathi:30",
    [21116] = "honor:258:pvpArathi:30",
    [21115] = "honor:382:pvpArathi:30",
    [20444] = "honor:65:pvpWarsong:20",
    [20443] = "honor:214:pvpWarsong:30",
    [20442] = "honor:65:pvpWarsong:20",
    [20441] = "honor:214:pvpWarsong:30",
    [20440] = "honor:214:pvpWarsong:30",
    [20439] = "honor:65:pvpWarsong:20",
    [20438] = "honor:214:pvpWarsong:30",
    [20437] = "honor:214:pvpWarsong:30",
    [20434] = "honor:428:pvpWarsong:40",
    [20431] = "honor:65:pvpWarsong:20",
    [20430] = "honor:214:pvpWarsong:30",
    [20429] = "honor:65:pvpWarsong:20",
    [20428] = "honor:65:pvpWarsong:10",
    [20427] = "honor:65:pvpWarsong:10",
    [20426] = "honor:65:pvpWarsong:20",
    [20425] = "honor:428:pvpWarsong:40",
    [20244] = "money:1000",
    [20243] = "money:2000",
    [20237] = "money:1500",
    [20235] = "money:1000",
    [20234] = "money:2000",
    [20232] = "money:1500",
    [20227] = "money:1500",
    [20226] = "money:1000",
    [20225] = "money:2000",
    [20224] = "money:1500",
    [20223] = "money:1000",
    [20222] = "money:2000",
    [20220] = "honor:15300:pvpArathi:40",
    [20214] = "honor:8160:pvpArathi:40",
    [20212] = "honor:8415:pvpArathi:40",
    [20211] = "honor:382:pvpArathi:20",
    [20210] = "honor:175:pvpArathi:20",
    [20209] = "honor:258:pvpArathi:20",
    [20208] = "honor:2805:pvpArathi:20",
    [20207] = "honor:175:pvpArathi:20",
    [20206] = "honor:258:pvpArathi:20",
    [20205] = "honor:382:pvpArathi:20",
    [20204] = "honor:2805:pvpArathi:20",
    [20203] = "honor:8415:pvpArathi:40",
    [20202] = "honor:382:pvpArathi:20",
    [20201] = "honor:175:pvpArathi:20",
    [20200] = "honor:258:pvpArathi:20",
    [20199] = "honor:2805:pvpArathi:20",
    [20198] = "honor:258:pvpArathi:20",
    [20197] = "honor:175:pvpArathi:20",
    [20196] = "honor:382:pvpArathi:20",
    [20195] = "honor:2805:pvpArathi:20",
    [20194] = "honor:8415:pvpArathi:40",
    [20193] = "honor:382:pvpArathi:20",
    [20192] = "honor:258:pvpArathi:20",
    [20191] = "honor:175:pvpArathi:20",
    [20190] = "honor:2805:pvpArathi:20",
    [20189] = "honor:382:pvpArathi:20",
    [20188] = "honor:175:pvpArathi:20",
    [20187] = "honor:258:pvpArathi:20",
    [20186] = "honor:2805:pvpArathi:20",
    [20185] = "honor:382:pvpArathi:20",
    [20184] = "honor:8415:pvpArathi:40",
    [20183] = "honor:258:pvpArathi:20",
    [20182] = "honor:175:pvpArathi:20",
    [20181] = "honor:2805:pvpArathi:20",
    [20180] = "honor:258:pvpArathi:20",
    [20179] = "honor:382:pvpArathi:20",
    [20178] = "honor:175:pvpArathi:20",
    [20177] = "honor:2805:pvpArathi:20",
    [20176] = "honor:8415:pvpArathi:40",
    [20175] = "honor:8415:pvpArathi:40",
    [20174] = "honor:382:pvpArathi:20",
    [20173] = "honor:258:pvpArathi:20",
    [20172] = "honor:175:pvpArathi:20",
    [20171] = "honor:2805:pvpArathi:20",
    [20170] = "honor:382:pvpArathi:20",
    [20169] = "honor:175:pvpArathi:20",
    [20168] = "honor:258:pvpArathi:20",
    [20167] = "honor:2805:pvpArathi:20",
    [20166] = "honor:258:pvpArathi:20",
    [20165] = "honor:382:pvpArathi:20",
    [20164] = "honor:175:pvpArathi:20",
    [20163] = "honor:2805:pvpArathi:20",
    [20162] = "honor:175:pvpArathi:20",
    [20161] = "honor:258:pvpArathi:20",
    [20160] = "honor:382:pvpArathi:20",
    [20159] = "honor:2805:pvpArathi:20",
    [20158] = "honor:8415:pvpArathi:40",
    [20157] = "honor:175:pvpArathi:20",
    [20156] = "honor:258:pvpArathi:20",
    [20155] = "honor:382:pvpArathi:20",
    [20154] = "honor:2805:pvpArathi:20",
    [20153] = "honor:258:pvpArathi:20",
    [20152] = "honor:175:pvpArathi:20",
    [20151] = "honor:382:pvpArathi:20",
    [20150] = "honor:2805:pvpArathi:20",
    [20129] = "honor:175:pvpArathi:20",
    [20128] = "honor:258:pvpArathi:20",
    [20127] = "honor:382:pvpArathi:20",
    [20126] = "honor:175:pvpArathi:20",
    [20125] = "honor:258:pvpArathi:20",
    [20124] = "honor:382:pvpArathi:20",
    [20123] = "honor:175:pvpArathi:20",
    [20122] = "honor:258:pvpArathi:20",
    [20121] = "honor:382:pvpArathi:20",
    [20120] = "honor:175:pvpArathi:20",
    [20119] = "honor:258:pvpArathi:20",
    [20118] = "honor:382:pvpArathi:20",
    [20117] = "honor:175:pvpArathi:20",
    [20116] = "honor:258:pvpArathi:20",
    [20115] = "honor:382:pvpArathi:20",
    [20114] = "honor:175:pvpArathi:20",
    [20113] = "honor:258:pvpArathi:20",
    [20112] = "honor:382:pvpArathi:20",
    [20111] = "honor:175:pvpArathi:20",
    [20110] = "honor:258:pvpArathi:20",
    [20109] = "honor:382:pvpArathi:20",
    [20108] = "honor:175:pvpArathi:20",
    [20107] = "honor:258:pvpArathi:20",
    [20106] = "honor:382:pvpArathi:20",
    [20105] = "honor:175:pvpArathi:20",
    [20104] = "honor:258:pvpArathi:20",
    [20103] = "honor:382:pvpArathi:20",
    [20102] = "honor:175:pvpArathi:20",
    [20101] = "honor:258:pvpArathi:20",
    [20100] = "honor:382:pvpArathi:20",
    [20099] = "honor:175:pvpArathi:20",
    [20098] = "honor:258:pvpArathi:20",
    [20097] = "honor:382:pvpArathi:20",
    [20096] = "honor:175:pvpArathi:20",
    [20095] = "honor:258:pvpArathi:20",
    [20094] = "honor:382:pvpArathi:20",
    [20093] = "honor:175:pvpArathi:20",
    [20092] = "honor:258:pvpArathi:20",
    [20091] = "honor:382:pvpArathi:20",
    [20090] = "honor:175:pvpArathi:20",
    [20089] = "honor:258:pvpArathi:20",
    [20088] = "honor:382:pvpArathi:20",
    [20073] = "honor:4590:pvpArathi:20",
    [20072] = "honor:2805:pvpArathi:30",
    [20071] = "honor:2805:pvpArathi:30",
    [20070] = "honor:8160:pvpArathi:40",
    [20069] = "honor:15300:pvpArathi:40",
    [20068] = "honor:4590:pvpArathi:20",
    [20061] = "honor:8415:pvpArathi:40",
    [20060] = "honor:8415:pvpArathi:40",
    [20059] = "honor:8415:pvpArathi:40",
    [20058] = "honor:8415:pvpArathi:40",
    [20057] = "honor:8415:pvpArathi:40",
    [20056] = "honor:8415:pvpArathi:40",
    [20055] = "honor:8415:pvpArathi:40",
    [20054] = "honor:2805:pvpArathi:20",
    [20053] = "honor:2805:pvpArathi:20",
    [20052] = "honor:2805:pvpArathi:20",
    [20051] = "honor:2805:pvpArathi:20",
    [20050] = "honor:2805:pvpArathi:20",
    [20049] = "honor:2805:pvpArathi:20",
    [20048] = "honor:2805:pvpArathi:20",
    [20047] = "honor:2805:pvpArathi:20",
    [20046] = "honor:2805:pvpArathi:20",
    [20045] = "honor:2805:pvpArathi:20",
    [20044] = "honor:2805:pvpArathi:20",
    [20043] = "honor:2805:pvpArathi:20",
    [20042] = "honor:2805:pvpArathi:20",
    [20041] = "honor:2805:pvpArathi:20",
    [19597] = "honor:422:pvpWarsong:20",
    [19596] = "honor:624:pvpWarsong:20",
    [19595] = "honor:4590:pvpWarsong:20",
    [19590] = "honor:422:pvpWarsong:20",
    [19589] = "honor:624:pvpWarsong:20",
    [19587] = "honor:4590:pvpWarsong:20",
    [19584] = "honor:422:pvpWarsong:20",
    [19583] = "honor:624:pvpWarsong:20",
    [19582] = "honor:4590:pvpWarsong:20",
    [19581] = "honor:422:pvpWarsong:20",
    [19580] = "honor:624:pvpWarsong:20",
    [19578] = "honor:4590:pvpWarsong:20",
    [19573] = "honor:632:pvpWarsong:40",
    [19572] = "honor:938:pvpWarsong:40",
    [19571] = "honor:1387:pvpWarsong:40",
    [19570] = "honor:10200:pvpWarsong:40",
    [19569] = "honor:632:pvpWarsong:40",
    [19568] = "honor:938:pvpWarsong:40",
    [19567] = "honor:1387:pvpWarsong:40",
    [19566] = "honor:10200:pvpWarsong:40",
    [19565] = "honor:316:pvpWarsong:30",
    [19564] = "honor:469:pvpWarsong:30",
    [19563] = "honor:694:pvpWarsong:30",
    [19562] = "honor:5100:pvpWarsong:30",
    [19561] = "honor:316:pvpWarsong:30",
    [19560] = "honor:469:pvpWarsong:30",
    [19559] = "honor:694:pvpWarsong:30",
    [19558] = "honor:5100:pvpWarsong:30",
    [19557] = "honor:316:pvpWarsong:30",
    [19556] = "honor:469:pvpWarsong:30",
    [19555] = "honor:694:pvpWarsong:30",
    [19554] = "honor:5100:pvpWarsong:30",
    [19553] = "honor:316:pvpWarsong:30",
    [19552] = "honor:469:pvpWarsong:30",
    [19551] = "honor:694:pvpWarsong:30",
    [19550] = "honor:10200:pvpWarsong:30",
    [19549] = "honor:316:pvpWarsong:30",
    [19548] = "honor:469:pvpWarsong:30",
    [19547] = "honor:694:pvpWarsong:30",
    [19546] = "honor:5100:pvpWarsong:30",
    [19545] = "honor:316:pvpWarsong:30",
    [19544] = "honor:469:pvpWarsong:30",
    [19543] = "honor:694:pvpWarsong:30",
    [19542] = "honor:5100:pvpWarsong:30",
    [19541] = "honor:95:pvpWarsong:20",
    [19540] = "honor:141:pvpWarsong:20",
    [19539] = "honor:208:pvpWarsong:20",
    [19538] = "honor:1530:pvpWarsong:20",
    [19537] = "honor:95:pvpWarsong:20",
    [19536] = "honor:141:pvpWarsong:20",
    [19535] = "honor:208:pvpWarsong:20",
    [19534] = "honor:1530:pvpWarsong:20",
    [19533] = "honor:95:pvpWarsong:10",
    [19532] = "honor:141:pvpWarsong:10",
    [19531] = "honor:208:pvpWarsong:10",
    [19530] = "honor:1530:pvpWarsong:10",
    [19529] = "honor:95:pvpWarsong:10",
    [19528] = "honor:141:pvpWarsong:10",
    [19527] = "honor:208:pvpWarsong:10",
    [19526] = "honor:1530:pvpWarsong:10",
    [19525] = "honor:95:pvpWarsong:20",
    [19524] = "honor:141:pvpWarsong:20",
    [19523] = "honor:208:pvpWarsong:20",
    [19522] = "honor:1530:pvpWarsong:20",
    [19521] = "honor:95:pvpWarsong:20",
    [19520] = "honor:141:pvpWarsong:20",
    [19519] = "honor:208:pvpWarsong:20",
    [19518] = "honor:1530:pvpWarsong:20",
    [19517] = "honor:95:pvpWarsong:20",
    [19516] = "honor:208:pvpWarsong:20",
    [19515] = "honor:141:pvpWarsong:20",
    [19514] = "honor:1530:pvpWarsong:20",
    [19513] = "honor:95:pvpWarsong:20",
    [19512] = "honor:141:pvpWarsong:20",
    [19511] = "honor:208:pvpWarsong:20",
    [19510] = "honor:1530:pvpWarsong:20",
    [19506] = "pvpWarsong:60",
    [19505] = "pvpWarsong:60",
    [19325] = "honor:4590:pvpAlterac:25",
    [19324] = "honor:4760:pvpAlterac:25",
    [19323] = "honor:4760:pvpAlterac:25",
    [19321] = "honor:4760:pvpAlterac:25",
    [19320] = "honor:1530:pvpAlterac:10",
    [19319] = "honor:1530:pvpAlterac:10",
    [19318] = "money:5000",
    [19317] = "money:6000",
    [19316] = "money:6000",
    [19315] = "honor:4760:pvpAlterac:25",
    [19312] = "honor:4760:pvpAlterac:25",
    [19311] = "honor:4760:pvpAlterac:25",
    [19310] = "honor:4760:pvpAlterac:25",
    [19309] = "honor:4760:pvpAlterac:25",
    [19308] = "honor:4760:pvpAlterac:25",
    [19307] = "money:8000",
    [19301] = "money:7000",
    [19104] = "honor:2380:pvpAlterac:10",
    [19103] = "honor:2380:pvpAlterac:10",
    [19102] = "honor:2720:pvpAlterac:15",
    [19101] = "honor:2720:pvpAlterac:15",
    [19100] = "honor:2380:pvpAlterac:10",
    [19099] = "honor:2380:pvpAlterac:10",
    [19098] = "honor:1530:pvpAlterac:20",
    [19097] = "honor:1530:pvpAlterac:20",
    [19096] = "honor:1530:pvpAlterac:20",
    [19095] = "honor:1530:pvpAlterac:20",
    [19094] = "honor:2805:pvpAlterac:20",
    [19093] = "honor:2805:pvpAlterac:20",
    [19092] = "honor:2805:pvpAlterac:20",
    [19091] = "honor:2805:pvpAlterac:20",
    [19090] = "honor:2805:pvpAlterac:20",
    [19089] = "honor:2805:pvpAlterac:20",
    [19088] = "honor:2805:pvpAlterac:20",
    [19087] = "honor:2805:pvpAlterac:20",
    [19086] = "honor:1530:pvpAlterac:10",
    [19085] = "honor:1530:pvpAlterac:10",
    [19084] = "honor:1530:pvpAlterac:10",
    [19083] = "honor:1530:pvpAlterac:10",
    [19068] = "money:1000",
    [19067] = "money:1500",
    [19066] = "money:2000",
    [19062] = "money:1000",
    [19061] = "money:1500",
    [19060] = "money:2000",
    [19046] = "pvpAlterac:30",
    [19045] = "pvpAlterac:30",
    [19032] = "pvpAlterac:60",
    [19031] = "pvpAlterac:60",
    [19030] = "pvpAlterac:50",
    [19029] = "pvpAlterac:50",
    [18877] = "honor:19125:pvpAlterac:40",
    [18876] = "honor:19125:pvpAlterac:40",
    [18874] = "honor:19125:pvpAlterac:40",
    [18873] = "honor:19125:pvpAlterac:40",
    [18871] = "honor:19125:pvpAlterac:40",
    [18869] = "honor:19125:pvpAlterac:40",
    [18868] = "honor:19125:pvpAlterac:40",
    [18867] = "honor:19125:pvpAlterac:40",
    [18866] = "honor:9563:pvpArathi:20",
    [18865] = "honor:9563:pvpArathi:20",
    [18864] = "honor:2805",
    [18863] = "honor:2805",
    [18862] = "honor:2805",
    [18860] = "honor:9563:pvpArathi:20",
    [18859] = "honor:2805",
    [18858] = "honor:2805",
    [18857] = "honor:2805",
    [18856] = "honor:2805",
    [18855] = "honor:9563:pvpArathi:20",
    [18854] = "honor:2805",
    [18853] = "honor:2805",
    [18852] = "honor:2805",
    [18851] = "honor:2805",
    [18850] = "honor:2805",
    [18849] = "honor:2805",
    [18848] = "honor:9563:pvpArathi:20",
    [18847] = "honor:9563:pvpArathi:20",
    [18846] = "honor:2805",
    [18845] = "honor:2805",
    [18844] = "honor:9563:pvpArathi:20",
    [18843] = "honor:9563:pvpArathi:20",
    [18841] = "money:900:honor:1",
    [18840] = "honor:9563:pvpArathi:20",
    [18839] = "money:900:honor:1",
    [18838] = "honor:9563:pvpArathi:20",
    [18837] = "honor:9563:pvpArathi:20",
    [18836] = "honor:9563:pvpArathi:20",
    [18835] = "honor:9563:pvpArathi:20",
    [18834] = "honor:2805",
    [18833] = "honor:9563:pvpArathi:20",
    [18831] = "honor:19125:pvpAlterac:40",
    [18830] = "honor:19125:pvpAlterac:40",
    [18828] = "honor:9563:pvpArathi:20",
    [18827] = "honor:9563:pvpArathi:20",
    [18826] = "honor:9563:pvpArathi:20",
    [18825] = "honor:9563:pvpArathi:20",
    [18607] = "honor:7650",
    [18606] = "honor:7650",
    [18461] = "honor:1530:pvpArathi:10",
    [18457] = "honor:208:pvpWarsong:10",
    [18456] = "honor:1530:pvpWarsong:10",
    [18455] = "honor:208:pvpWarsong:10",
    [18454] = "honor:1530:pvpWarsong:10",
    [18453] = "honor:208:pvpWarsong:10",
    [18452] = "honor:1530:pvpWarsong:10",
    [18449] = "honor:208:pvpWarsong:10",
    [18448] = "honor:1530:pvpWarsong:10",
    [18447] = "honor:208:pvpWarsong:10",
    [18445] = "honor:1530:pvpWarsong:10",
    [18444] = "honor:208:pvpWarsong:20",
    [18443] = "honor:1530:pvpWarsong:20",
    [18442] = "honor:95:pvpWarsong:20",
    [18441] = "honor:208:pvpArathi:10",
    [18440] = "honor:95:pvpArathi:10",
    [18437] = "honor:208:pvpWarsong:10",
    [18436] = "honor:208:pvpWarsong:10",
    [18435] = "honor:208:pvpWarsong:10",
    [18434] = "honor:1530:pvpWarsong:10",
    [18432] = "honor:208:pvpWarsong:10",
    [18430] = "honor:208:pvpWarsong:10",
    [18429] = "honor:1530:pvpWarsong:10",
    [18428] = "honor:208:pvpWarsong:20",
    [18427] = "honor:95:pvpArathi:10",
    [17625] = "honor:13005:pvpWarsong:30",
    [17624] = "honor:13770:pvpArathi:30",
    [17623] = "honor:13005:pvpAlterac:30",
    [17622] = "honor:8415:pvpArathi:20",
    [17620] = "honor:8415:pvpAlterac:20",
    [17618] = "honor:8415:pvpArathi:20",
    [17608] = "honor:8415:pvpAlterac:20",
    [17607] = "honor:8415:pvpArathi:20",
    [17605] = "honor:13770:pvpArathi:30",
    [17604] = "honor:8415:pvpArathi:20",
    [17603] = "honor:13005:pvpWarsong:30",
    [17602] = "honor:13005:pvpAlterac:30",
    [17593] = "honor:13005:pvpWarsong:30",
    [17592] = "honor:13770:pvpArathi:30",
    [17591] = "honor:13005:pvpAlterac:30",
    [17590] = "honor:8415:pvpArathi:20",
    [17588] = "honor:8415:pvpAlterac:20",
    [17586] = "honor:8415:pvpArathi:20",
    [17584] = "honor:8415:pvpAlterac:20",
    [17583] = "honor:8415:pvpArathi:20",
    [17581] = "honor:13770:pvpArathi:30",
    [17580] = "honor:8415:pvpArathi:20",
    [17579] = "honor:13005:pvpWarsong:30",
    [17578] = "honor:13005:pvpAlterac:30",
    [17352] = "money:500",
    [17351] = "money:1000",
    [17349] = "money:500",
    [17348] = "money:1000",
    [16580] = "honor:8415:pvpArathi:20",
    [16579] = "honor:13005:pvpWarsong:30",
    [16578] = "honor:13005:pvpAlterac:30",
    [16577] = "honor:13770:pvpArathi:30",
    [16574] = "honor:8415:pvpAlterac:20",
    [16573] = "honor:8415:pvpArathi:20",
    [16571] = "honor:8415:pvpAlterac:20",
    [16569] = "honor:8415:pvpArathi:20",
    [16568] = "honor:8415:pvpArathi:20",
    [16567] = "honor:13005:pvpWarsong:30",
    [16566] = "honor:13005:pvpAlterac:30",
    [16565] = "honor:13770:pvpArathi:30",
    [16564] = "honor:13005:pvpWarsong:30",
    [16563] = "honor:13770:pvpArathi:30",
    [16562] = "honor:8415:pvpArathi:20",
    [16561] = "honor:13005:pvpAlterac:30",
    [16560] = "honor:8415:pvpAlterac:20",
    [16558] = "honor:8415:pvpArathi:20",
    [16555] = "honor:8415:pvpAlterac:20",
    [16554] = "honor:8415:pvpArathi:20",
    [16552] = "honor:13005:pvpWarsong:30",
    [16551] = "honor:8415:pvpArathi:20",
    [16550] = "honor:13005:pvpAlterac:30",
    [16549] = "honor:13770:pvpArathi:30",
    [16548] = "honor:8415:pvpAlterac:20",
    [16545] = "honor:8415:pvpArathi:20",
    [16544] = "honor:8415:pvpArathi:20",
    [16543] = "honor:13005:pvpWarsong:30",
    [16542] = "honor:13005:pvpAlterac:30",
    [16541] = "honor:13770:pvpArathi:30",
    [16540] = "honor:8415:pvpAlterac:20",
    [16539] = "honor:8415:pvpArathi:20",
    [16536] = "honor:8415:pvpArathi:20",
    [16535] = "honor:13770:pvpArathi:30",
    [16534] = "honor:13005:pvpWarsong:30",
    [16533] = "honor:13005:pvpAlterac:30",
    [16532] = "honor:1530:pvpWarsong:10",
    [16497] = "honor:1530:pvpWarsong:10",
    [16486] = "honor:1530:pvpWarsong:10",
    [16484] = "honor:8415:pvpAlterac:20",
    [16483] = "honor:8415:pvpArathi:20",
    [16480] = "honor:8415:pvpArathi:20",
    [16479] = "honor:13005:pvpWarsong:30",
    [16478] = "honor:13005:pvpAlterac:30",
    [16477] = "honor:13770:pvpArathi:30",
    [16476] = "honor:8415:pvpArathi:20",
    [16475] = "honor:13005:pvpWarsong:30",
    [16474] = "honor:13005:pvpAlterac:30",
    [16473] = "honor:13770:pvpArathi:30",
    [16472] = "honor:8415:pvpArathi:20",
    [16471] = "honor:8415:pvpAlterac:20",
    [16468] = "honor:8415:pvpArathi:20",
    [16467] = "honor:13005:pvpWarsong:30",
    [16466] = "honor:13770:pvpArathi:30",
    [16465] = "honor:13005:pvpAlterac:30",
    [16463] = "honor:8415:pvpAlterac:20",
    [16462] = "honor:8415:pvpArathi:20",
    [16459] = "honor:8415:pvpArathi:20",
    [16457] = "honor:8415:pvpArathi:20",
    [16456] = "honor:13005:pvpWarsong:30",
    [16455] = "honor:13005:pvpAlterac:30",
    [16454] = "honor:8415:pvpAlterac:20",
    [16453] = "honor:13770:pvpArathi:30",
    [16452] = "honor:13770:pvpArathi:30",
    [16451] = "honor:13005:pvpAlterac:30",
    [16450] = "honor:13005:pvpWarsong:30",
    [16449] = "honor:8415:pvpArathi:20",
    [16448] = "honor:8415:pvpAlterac:20",
    [16446] = "honor:8415:pvpArathi:20",
    [16444] = "honor:8415:pvpArathi:20",
    [16443] = "honor:13770:pvpArathi:30",
    [16442] = "honor:13005:pvpWarsong:30",
    [16441] = "honor:13005:pvpAlterac:30",
    [16440] = "honor:8415:pvpAlterac:20",
    [16437] = "honor:8415:pvpArathi:20",
    [16345] = "honor:9563:pvpArathi:20",
    [16342] = "honor:1530:pvpArathi:10",
    [16341] = "honor:208:pvpArathi:10",
    [16335] = "honor:1530:pvpWarsong:20",
    [15200] = "honor:95:pvpWarsong:20",
    [15199] = "pvpAlterac:20:pvpArathi:20:pvpWarsong:20",
    [15198] = "pvpAlterac:20:pvpArathi:20:pvpWarsong:20",
    [15197] = "pvpArathi:3:pvpWarsong:3",
    [15196] = "pvpArathi:3:pvpWarsong:3",
    [12584] = "honor:9563:pvpArathi:20",
--@end-version-bcc@
}

function VendorPrice.ItemHasVendorPrice(itemID)
    return VENDOR_PRICES[itemID] ~= nil
end

function VendorPrice.GetVendorPriceForItem(itemID)
    return VENDOR_PRICES[itemID]
end

function VendorPrice.GetPriceInfoList()
    return PRICE_INFO_LIST
end
